/***************************************************************************/
/*  BURPD                                                                  */
/*     - Bi-directional Useless Reference Ping Server                      */
/*                                                                         */
/*  Jill T. Bodine                                                         */
/*  John C. Broughton III                                                  */
/*  Erik J. Erikson                                                        */
/*                                                                         */
/***************************************************************************/

#include "cpic.h"
#include <stdio.h>
#include <stdlib.h>
#define  INCL_DOSPROCESS
#include <os2.h>
#include <time.h>

#define  MAX_BUFFER_SIZE      (32763)
#define  MAX_PLU_NAME_LEN     (17+1)

void quit( unsigned char );

void main()
{
    /* Variables used for CPI-C calls */
    unsigned char conv_id[8];               /* CPI-C conversation ID         */
    CM_INT32 rc;                            /* CPI-C return code             */
    CM_INT32 length;                        /* General length variable       */
    CM_INT32 rts_received;                  /* Request to send rcvd          */
    CM_INT32 max_rcv_len = MAX_BUFFER_SIZE; /* Max rcv length on CMRCV       */
    CM_INT32 data_received;                 /* Data rcv parm from CMRCV      */
    CM_INT32 received_len;                  /* Amount of data rcvd on CMRCV  */
    CM_INT32 status_received;               /* Status from CMRCV             */
    unsigned char * buffer = NULL;          /* Data buffer for send and rcv  */
    unsigned char plu_name[MAX_PLU_NAME_LEN]; /* Partner LU name             */

    /* Variables for the CPI-C Set calls */
    CM_SEND_TYPE send_type;                 /* How to handle send data */
    CM_DEALLOCATE_TYPE deallocate_type;     /* How to end the conv */
    CM_SEND_RECEIVE_MODE send_receive_mode; /* FDX or HDX */

    unsigned short i, freq, duration ;      /* variables used to create */
                                            /*  the sound effects       */

    /*
     * Say hello.
     */
    puts( "BURPD - Bi-directional Useless Reference Ping Server." );
    puts( "  Jill T. Bodine" );
    puts( "  John C. Broughton III" );
    puts( "  Erik J. Erikson\n\n" );

    /*
     * Allocate a send and receive data buffer. This is NOT the best way
     * in OS/2. We should be allocating shared memory to avoid a
     * data copy, as CPI-C must pass our data to APPC via shared memory.
     */
    buffer = malloc( (unsigned short)MAX_BUFFER_SIZE );
    if (NULL == buffer) {
        puts( "Memory could not be allocated.\nExiting..." );
        quit( EXIT_FAILURE );
    }

    /*
     * Initialize the incoming conversation. This gives us a conversation ID
     * that we use for all subsequent CPI-C calls.
     */
    cminic( conv_id, &rc );
    if (CM_OK != rc) {
        printf( "Error in cminic. CPI-C rc = %lu", rc );
        quit( EXIT_FAILURE );
    }

    /*
     * Set the expected send/receive mode.
     */
    send_receive_mode = XC_FDX_OR_FDX_SIM;
    cmssrm( conv_id, &send_receive_mode, &rc );
    if (CM_OK != rc) {
        printf( "Error in cmssrm. CPI-C rc = %lu", rc );
        quit( EXIT_FAILURE );
    }

    /*
     * Accept the incoming conversation.
     */
    cmacci( conv_id, &rc );
    if (CM_OK != rc) {
        printf( "Error in cmacci. CPI-C rc = %lu", rc );
        quit( EXIT_FAILURE );
    }

    /*
     * Extract the partner LU name and display it.
     */
    cmepln( conv_id, plu_name, &length, &rc );
    if (CM_OK != rc) {
        printf( "Error in cmepln. CPI-C rc = %lu", rc );
        quit( EXIT_FAILURE );
    }
    plu_name[length] = '\0';

    /*
     * Receive MAX_BUFFER_SIZE bytes of useless data.
     */
    cmrcv( conv_id,                  /* Receive Data                  */
           buffer,                   /* Data Pointer                  */
           &max_rcv_len,             /* Size of Data Buffer           */
           &data_received,           /* returned - data received      */
           &received_len,            /* returned - length of data     */
           &status_received,         /* returned - status received    */
           &rts_received,            /* returned - request to send    */
           &rc );
    if (CM_OK != rc) {
        printf( "Error in cmrcv. CPI-C rc = %lu", rc );
        quit( EXIT_FAILURE );
    }

    /*
     * Burp! (Hz, milliseconds)
     */
    srand( (unsigned short)time( NULL ) );
    for (i=1; i<60; i++) {
        freq = rand() % 50;
        duration = rand() % 4;
        DosBeep( freq, duration );
        }
    printf( "%s\n", buffer );
    printf( "\nBurped by: %s\n", plu_name );

    /*
     * Set the send type to indicate we want to flush. With full-duplex,
     * the receive that follows our send will not flush our send data.
     */
    send_type = CM_SEND_AND_FLUSH;
    cmsst( conv_id, &send_type, &rc );
    if (CM_OK != rc) {
        printf( "Error in cmsst. CPI-C rc = %lu", rc );
        quit( EXIT_FAILURE );
    }

    /*
     * Send back the useless data.
     */
    cmsend( conv_id,
            buffer,
            &received_len,
            &rts_received,
            &rc );
    if (CM_OK != rc) {
        printf( "Error in cmsend. CPI-C rc = %lu", rc );
        quit( EXIT_FAILURE );
    }

    /*
     * Receive an indication that our partner has deallocated his side
     * of the conversation.
     */
    cmrcv( conv_id,                  /* Receive Data                  */
           buffer,                   /* Data Pointer                  */
           &max_rcv_len,             /* Size of Data Buffer           */
           &data_received,           /* returned - data received      */
           &received_len,            /* returned - length of data     */
           &status_received,         /* returned - status received    */
           &rts_received,            /* returned - request to send    */
           &rc );

    if (CM_DEALLOCATED_NORMAL != rc) {
        printf( "Error in cmrcv. CPI-C rc = %lu", rc );
        quit( EXIT_FAILURE );
    }

    /*
     * Set the deallocate type so our deallocate will flush.
     */
    deallocate_type = CM_DEALLOCATE_FLUSH;
    cmsdt( conv_id, &deallocate_type, &rc );
    if (CM_OK != rc) {
        printf( "Error in cmsdt. CPI-C rc = %lu", rc );
        quit( EXIT_FAILURE );
    }

    /*
     * Deallocate our side of the conversation.
     */
    cmdeal( conv_id, &rc );
    if (CM_OK != rc) {
        printf( "Error in cmdeal. CPI-C rc = %lu", rc );
        quit( EXIT_FAILURE );
    }

    exit( EXIT_SUCCESS );
}

void quit( unsigned char exit_type )
{
    printf( "\n\nPress any key to quit...\n" );
    getchar();
    exit( exit_type );
}

